<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-plus-circle me-2"></i>Tambah Project
    </h2>
    <a href="<?= base_url('admin/projects') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/projects/store') ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="nama_project" class="form-label">Nama Project <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="nama_project" name="nama_project" 
                       value="<?= old('nama_project') ?>" required>
            </div>
            <div class="col-md-3 mb-3">
                <label for="jenis_project" class="form-label">Jenis Project <span class="text-danger">*</span></label>
                <select class="form-select" id="jenis_project" name="jenis_project" required>
                    <option value="">Pilih Jenis</option>
                    <option value="Web" <?= old('jenis_project') === 'Web' ? 'selected' : '' ?>>Web</option>
                    <option value="Mobile" <?= old('jenis_project') === 'Mobile' ? 'selected' : '' ?>>Mobile</option>
                    <option value="Game" <?= old('jenis_project') === 'Game' ? 'selected' : '' ?>>Game</option>
                    <option value="Desktop" <?= old('jenis_project') === 'Desktop' ? 'selected' : '' ?>>Desktop</option>
                    <option value="Lainnya" <?= old('jenis_project') === 'Lainnya' ? 'selected' : '' ?>>Lainnya</option>
                </select>
            </div>
            <div class="col-md-3 mb-3">
                <label for="tahun" class="form-label">Tahun</label>
                <input type="number" class="form-control" id="tahun" name="tahun" 
                       value="<?= old('tahun') ?>" min="1900" max="2100" placeholder="Contoh: 2023">
            </div>
        </div>

        <div class="mb-3">
            <label for="teknologi" class="form-label">Teknologi</label>
            <textarea class="form-control" id="teknologi" name="teknologi" rows="2" 
                      placeholder="Contoh: PHP, JavaScript, React, MySQL"><?= old('teknologi') ?></textarea>
        </div>

        <div class="mb-3">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            
            <div class="position-relative">
                <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                          placeholder="Tulis deskripsi proyek..."><?= old('deskripsi') ?></textarea>
                

            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="link_project" class="form-label">Link Project</label>
                <input type="url" class="form-control" id="link_project" name="link_project" 
                       value="<?= old('link_project') ?>" placeholder="https://...">
            </div>
            <div class="col-md-3 mb-3">
                <label for="urutan" class="form-label">Urutan</label>
                <input type="number" class="form-control" id="urutan" name="urutan" 
                       value="<?= old('urutan', 0) ?>" min="0">
            </div>
            <div class="col-md-3 mb-3">
                <label for="foto" class="form-label">Foto Project</label>
                <input type="file" class="form-control" id="foto" name="foto" 
                       accept="image/jpeg,image/png,image/gif">
                <small class="text-white">Format: JPG, PNG, GIF (Max: 2MB)</small>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Simpan
            </button>
            <a href="<?= base_url('admin/projects') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>




